/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.AudioOutput;
import ddf.minim.Minim;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class UGen {
    private ArrayList<UGenInput> m_allInputs = new ArrayList();
    private float[] m_lastValues = new float[2];
    private float m_sampleRate;
    private int m_nOutputs = 0;
    private int m_currentTick = 0;

    public final UGen patch(UGen uGen) {
        this.setSampleRate(uGen.m_sampleRate);
        uGen.addInput(this);
        ++this.m_nOutputs;
        Minim.debug("m_nOutputs = " + this.m_nOutputs);
        return uGen;
    }

    public final UGen patch(UGenInput uGenInput) {
        this.setSampleRate(uGenInput.getOuterUGen().m_sampleRate);
        uGenInput.setIncomingUGen(this);
        ++this.m_nOutputs;
        Minim.debug("m_nOutputs = " + this.m_nOutputs);
        return uGenInput.getOuterUGen();
    }

    protected void addInput(UGen uGen) {
        Minim.debug("UGen addInput called.");
        if (this.m_allInputs.size() > 0) {
            Minim.debug("Initializing default input on something");
            this.m_allInputs.get(0).setIncomingUGen(uGen);
        } else {
            System.err.println("Trying to connect to UGen with no default input.");
        }
    }

    public final void patch(AudioOutput audioOutput) {
        Minim.debug("Patching " + this + " to the output " + audioOutput + ".");
        this.setSampleRate(audioOutput.sampleRate());
        this.setAudioChannelCount(audioOutput.getFormat().getChannels());
        this.patch(audioOutput.bus);
    }

    public final void unpatch(AudioOutput audioOutput) {
        Minim.debug("Unpatching " + this + " from the output " + audioOutput + ".");
        this.unpatch(audioOutput.bus);
    }

    public final void unpatch(UGen uGen) {
        uGen.removeInput(this);
        --this.m_nOutputs;
        Minim.debug("m_nOutputs = " + this.m_nOutputs);
    }

    protected void removeInput(UGen uGen) {
        Minim.debug("UGen removeInput called.");
        for (int i = 0; i < this.m_allInputs.size(); ++i) {
            if (this.m_allInputs.get(i).getIncomingUGen() != uGen) continue;
            this.m_allInputs.get(i).setIncomingUGen(null);
        }
    }

    public final void tick(float[] fArray) {
        if (fArray.length > 2) {
            throw new IllegalArgumentException("UGen cannot currently handle more than 2 channels of audio!");
        }
        if (this.m_nOutputs > 0) {
            this.m_currentTick = (this.m_currentTick + 1) % this.m_nOutputs;
        }
        if (0 == this.m_currentTick) {
            for (int i = 0; i < this.m_allInputs.size(); ++i) {
                this.m_allInputs.get(i).tick();
            }
            this.uGenerate(fArray);
            if (fArray.length == 1) {
                this.m_lastValues[0] = fArray[0];
                this.m_lastValues[1] = fArray[0];
            } else if (fArray.length == 2) {
                System.arraycopy(fArray, 0, this.m_lastValues, 0, fArray.length);
            }
        } else if (fArray.length == 1) {
            fArray[0] = this.m_lastValues[0] * 0.5f;
            fArray[0] = fArray[0] + this.m_lastValues[1] * 0.5f;
        } else if (fArray.length == 2) {
            System.arraycopy(this.m_lastValues, 0, fArray, 0, 2);
        }
    }

    protected abstract void uGenerate(float[] var1);

    public final float[] getLastValues() {
        return this.m_lastValues;
    }

    public final float sampleRate() {
        return this.m_sampleRate;
    }

    protected void sampleRateChanged() {
    }

    public final void setSampleRate(float f) {
        if (this.m_sampleRate != f) {
            this.m_sampleRate = f;
            this.sampleRateChanged();
            for (int i = 0; i < this.m_allInputs.size(); ++i) {
                UGen uGen = this.m_allInputs.get(i).getIncomingUGen();
                if (uGen == null) continue;
                uGen.setSampleRate(f);
            }
        }
    }

    public void setAudioChannelCount(int n) {
        for (int i = 0; i < this.m_allInputs.size(); ++i) {
            UGenInput uGenInput = this.m_allInputs.get(i);
            if (uGenInput.getInputType() != InputType.AUDIO) continue;
            uGenInput.setChannelCount(n);
        }
    }

    public void printInputs() {
        for (int i = 0; i < this.m_allInputs.size(); ++i) {
            Minim.debug("m_allInputs " + i + " ");
            if (this.m_allInputs.get(i) == null) {
                Minim.debug("null");
                continue;
            }
            this.m_allInputs.get(i).printInput();
        }
    }

    protected UGenInput addControl() {
        return new UGenInput(InputType.CONTROL);
    }

    protected UGenInput addControl(float f) {
        return new UGenInput(InputType.CONTROL, f);
    }

    protected UGenInput addAudio() {
        return new UGenInput(InputType.AUDIO);
    }

    public final class UGenInput {
        private UGen m_incoming;
        private InputType m_inputType;
        private float[] m_lastValues;

        public UGenInput() {
            this(InputType.AUDIO);
        }

        public UGenInput(InputType inputType) {
            this.m_inputType = inputType;
            UGen.this.m_allInputs.add(this);
            this.m_lastValues = new float[1];
        }

        public UGenInput(InputType inputType, float f) {
            this.m_inputType = inputType;
            UGen.this.m_allInputs.add(this);
            this.m_lastValues = new float[1];
            this.m_lastValues[0] = f;
        }

        public void setChannelCount(int n) {
            if (this.m_lastValues.length != n) {
                float f = this.m_lastValues.length > 0 ? this.m_lastValues[0] : 0.0f;
                this.m_lastValues = new float[n];
                Arrays.fill(this.m_lastValues, f);
            }
            if (this.m_inputType == InputType.AUDIO && this.m_incoming != null) {
                this.m_incoming.setAudioChannelCount(n);
            }
        }

        public int channelCount() {
            return this.m_lastValues.length;
        }

        public InputType getInputType() {
            return this.m_inputType;
        }

        public UGen getOuterUGen() {
            return UGen.this;
        }

        public UGen getIncomingUGen() {
            return this.m_incoming;
        }

        public void setIncomingUGen(UGen uGen) {
            this.m_incoming = uGen;
            if (this.m_incoming != null && this.m_inputType == InputType.AUDIO) {
                this.m_incoming.setAudioChannelCount(this.m_lastValues.length);
            }
        }

        public boolean isPatched() {
            return this.m_incoming != null;
        }

        public float[] getLastValues() {
            return this.m_lastValues;
        }

        public float getLastValue() {
            return this.m_lastValues[0];
        }

        public void setLastValue(float f) {
            for (int i = 0; i < this.m_lastValues.length; ++i) {
                this.m_lastValues[i] = f;
            }
        }

        void tick() {
            if (this.m_incoming != null) {
                this.m_incoming.tick(this.m_lastValues);
            }
        }

        public String getInputTypeAsString() {
            String string = null;
            switch (this.m_inputType) {
                case AUDIO: {
                    string = "AUDIO";
                    break;
                }
                case CONTROL: {
                    string = "CONTROL";
                }
            }
            return string;
        }

        public void printInput() {
            Minim.debug("UGenInput:  signal = " + this.getInputTypeAsString() + " " + (this.m_incoming != null));
        }
    }

    public static enum InputType {
        CONTROL,
        AUDIO;

    }
}

